<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateServiceTypeToJsonInAvailableForTable extends Migration
{
    public function up()
    {
        Schema::table('available_for', function (Blueprint $table) {
            $table->json('service_type')->change(); // Convert existing service_type to JSON
        });
    }

    public function down()
    {
        Schema::table('available_for', function (Blueprint $table) {
            $table->string('service_type')->change(); // Revert to string if rolled back
        });
    }
}
